-- BA Pack 1 [Abydos-Gehenna-Highlander]
-- Character Voice Tables

-- ================================================================
-- Example
-- ================================================================
-- local VT_CHARNAME = {
--   [CHAR_SOUND_OKEY_DOKEY] = 'CharStartGame.ogg',                                       -- Starting game
--   [CHAR_SOUND_LETS_A_GO] = 'CharStartLevel.ogg',                                       -- Starting level
--   [CHAR_SOUND_GAME_OVER] = 'CharGameOver.ogg',                                         -- Game Overed
--   [CHAR_SOUND_PUNCH_YAH] = 'CharPunch1.ogg',                                           -- Punch 1
--   [CHAR_SOUND_PUNCH_WAH] = 'CharPunch2.ogg',                                           -- Punch 2
--   [CHAR_SOUND_PUNCH_HOO] = 'CharPunch3.ogg',                                           -- Punch 3
--   [CHAR_SOUND_YAH_WAH_HOO] = { 'CharJump1.ogg', 'CharJump2.ogg', 'CharJump3.ogg' },    -- First Jump Sounds
--   [CHAR_SOUND_HOOHOO] = 'CharDoubleJump.ogg',                                          -- Second jump sound
--   [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'CharTripleJump1.ogg', 'CharTripleJump2.ogg' },   -- Triple jump sounds
--   [CHAR_SOUND_UH] = 'CharBonk.ogg',                                                    -- Soft wall bonk
--   [CHAR_SOUND_UH2] = 'CharLedgeGetUp.ogg',                                             -- Quick ledge get up
--   [CHAR_SOUND_UH2_2] = 'CharLongJumpLand.ogg',                                         -- Landing after long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Hard wall bonk
--   [CHAR_SOUND_OOOF] = 'CharBonk.ogg',                                                  -- Attacked in air
--   [CHAR_SOUND_OOOF2] = 'CharBonk.ogg',                                                 -- Land from hard bonk
--   [CHAR_SOUND_HAHA] = 'CharTripleJumpLand.ogg',                                        -- Landing triple jump
--   [CHAR_SOUND_HAHA_2] = 'CharWaterLanding.ogg',                                        -- Landing in water from big fall
--   [CHAR_SOUND_YAHOO] = 'CharLongJump.ogg',                                             -- Long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Long jump wall bonk
--   [CHAR_SOUND_WHOA] = 'CharGrabLedge.ogg',                                             -- Grabbing ledge
--   [CHAR_SOUND_EEUH] = 'CharClimbLedge.ogg',                                            -- Climbing over ledge
--   [CHAR_SOUND_WAAAOOOW] = 'CharFalling.ogg',                                           -- Falling a long distance
--   [CHAR_SOUND_TWIRL_BOUNCE] = 'CharFlowerBounce.ogg',                                  -- Bouncing off of a flower spring
--   [CHAR_SOUND_GROUND_POUND_WAH] = 'CharGroundPound.ogg',                               -- Ground Pound after startup
--   [CHAR_SOUND_WAH2] = 'CharThrow.ogg',                                                 -- Throwing something
--   [CHAR_SOUND_HRMM] = 'CharLift.ogg',                                                  -- Lifting something
--   [CHAR_SOUND_HERE_WE_GO] = 'CharGetStar.ogg',                                         -- Star get
--   [CHAR_SOUND_SO_LONGA_BOWSER] = 'CharThrowBowser.ogg',                                -- Throwing Bowser
--   --DAMAGE
--   [CHAR_SOUND_ATTACKED] = 'CharDamaged.ogg',                                           -- Damaged
--   [CHAR_SOUND_PANTING] = 'CharPanting.ogg',                                            -- Low health
--   [CHAR_SOUND_PANTING_COLD] = 'CharPanting.ogg',                                       -- Getting cold
--   [CHAR_SOUND_ON_FIRE] = 'CharBurned.ogg',                                             -- Burned
--   --SLEEP SOUNDS
--   [CHAR_SOUND_IMA_TIRED] = 'CharTired.ogg',                                            -- Mario feeling tired
--   [CHAR_SOUND_YAWNING] = 'CharYawn.ogg',                                               -- Mario yawning before he sits down to sleep
--   [CHAR_SOUND_SNORING1] = 'CharSnore.ogg',                                             -- Snore Inhale
--   [CHAR_SOUND_SNORING2] = 'CharExhale.ogg',                                            -- Exhale
--   [CHAR_SOUND_SNORING3] = 'CharSleepTalk.ogg',                                         -- Sleep talking / mumbling
--   --COUGHING (USED IN THE GAS MAZE)
--   [CHAR_SOUND_COUGHING1] = 'CharCough1.ogg',                                           -- Cough take 1
--   [CHAR_SOUND_COUGHING2] = 'CharCough2.ogg',                                           -- Cough take 2
--   [CHAR_SOUND_COUGHING3] = 'CharCough3.ogg',                                           -- Cough take 3
--   --DEATH
--   [CHAR_SOUND_DYING] = 'CharDying.ogg',                                                -- Dying from damage
--   [CHAR_SOUND_DROWNING] = 'CharDrowning.ogg',                                          -- Running out of air underwater
--   [CHAR_SOUND_MAMA_MIA] = 'CharLeaveLevel.ogg'                                         -- Booted out of level
-- }

-- ================================================================
-- NPC Voices
-- Files are in Main
-- ================================================================

VT_NOVOICE = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3', 'sfx_smrpg_shell.mp3', 'sfx_smw_bossstun.mp3', 'sfx_ff6_fistattack.mp3', 'sfx_smw_bossstun.mp3', 'sfx_mmx_hurt.mp3' },
  [CHAR_SOUND_DOH] = 'sfx_ml_bump.mp3',                                              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sfx_smb3_down.mp3', 'sfx_cv3_dead.mp3', 'sfx_earthbound_dead.mp3'},
  [CHAR_SOUND_HERE_WE_GO] = { 'sfx_alttp_item.mp3', 'sfx_smrpg_specialflower.mp3', 'sfx_earthbound_good.mp3', 'sfx_kirby_1up.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'sfx_smb3_levelselect.mp3' },                           -- Level Select
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                      -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'sfx_smw_jump.mp3' },                                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sfx_pm64_what.mp3',                                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                         -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                                 -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                     -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' },                       -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3' },                                 -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                   -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                              -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sfx_ssb64_superjump.mp3' },                                -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sfx_ssb64_superjump.mp3' },                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sfx_smw_jump.mp3' },                                 -- 1st Jump(s)
}

-- ================================================================
-- Voice Tables
-- ================================================================
-- ================
-- Abydos Start
-- ================
VT_SHOSHINO = {
  [CHAR_SOUND_ATTACKED] = { 'shoshino_dmg1.mp3', 'shoshino_dmg2.mp3' },
  [CHAR_SOUND_DYING] = 'shoshino_dying.mp3',
  [CHAR_SOUND_DOH] = 'shoshino_dmg1.mp3',
  [CHAR_SOUND_PUNCH_HOO] = 'shoshino_kick.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = 'shoshino_yahoo.mp3',
  [CHAR_SOUND_HAHA] = 'shoshino_laugh.mp3',
  [CHAR_SOUND_HAHA_2] = 'shoshino_laugh.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'shoshino_letsGo.mp3',
  [CHAR_SOUND_HOOHOO] = { 'shoshino_jump2.mp3' },
  [CHAR_SOUND_YAHOO] = 'shoshino_yahoo.mp3',
  [CHAR_SOUND_EEUH] = 'shoshino_ledgeUp.mp3',
  [CHAR_SOUND_MAMA_MIA] = 'shoshino_levelFail.mp3',
  [CHAR_SOUND_HRMM] = 'shoshino_hmm.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'shoshino_star.mp3', 'shoshino_star2.mp3' },
  [CHAR_SOUND_UH] = 'shoshino_eh.mp3',
  [CHAR_SOUND_OOOF] = 'shoshino_dmg1.mp3',
  [CHAR_SOUND_YAH_WAH_HOO] = { 'shoshino_jump1.mp3', 'shoshino_jump4.mp3', 'shoshino_punch1.mp3' },
  [CHAR_SOUND_OOOF2] = 'shoshino_dmg2.mp3',
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = 'shoshino_jump3.mp3',
  [CHAR_SOUND_PUNCH_WAH] = 'shoshino_punch1.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'shoshino_punch2.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'shoshino_falling.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'shoshino_bowser.mp3' },
  [CHAR_SOUND_WHOA] = 'shoshino_oh.mp3',
  [CHAR_SOUND_ON_FIRE] = 'shoshino_burn.mp3',
  [CHAR_SOUND_IMA_TIRED] = 'shoshino_sleepy.mp3',
}

VT_SHIROKO       = {
  [CHAR_SOUND_ATTACKED] = { 'srk_dmg1.mp3', 'srk_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'srk_eh.mp3',         -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'srk_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'srk_climb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'.mp3'},
  [CHAR_SOUND_HAHA] = { 'srk_ok.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'srk_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'srk_atk1.mp3' },      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'srk_ok.mp3',              -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'srk_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'srk_ls1.mp3' },    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'srk_getup.mp3' },   -- Getting up after thrown out of level
  -- [CHAR_SOUND_ON_FIRE] = {'wkm_dmg4.mp3'}, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'srk_eh.mp3',              -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'srk_dmg1.mp3',           -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'srk_atk6.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'srk_atk4.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'srk_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'srk_bthrow1.mp3', 'srk_bthrow2.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'srk_nn1.mp3' },                           -- Boing
  [CHAR_SOUND_UH] = 'srk_nn2.mp3',                                         -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'srk_nn1.mp3' },                                    -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'srk_throw1.mp3', 'srk_throw2.mp3' },    -- Throw Object
  [CHAR_SOUND_WHOA] = 'srk_nn2.mp3',                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'srk_atk3.mp3' },                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'srk_atk3.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'srk_atk2.mp3', 'srk_atk5.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shun_yawn.mp3'},
}

VT_SHIROKOTERROR = {
  [CHAR_SOUND_ATTACKED] = { 'srk_dmg1.mp3', 'srk_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'srk_eh.mp3',         -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'srkt_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'srk_climb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'.mp3'},
  [CHAR_SOUND_HAHA] = { 'srk_ok.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'srkt_star1.mp3', 'srkt_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'srk_atk1.mp3' },                         -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'srk_ok.mp3',                                 -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'srkt_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'srk_ls1.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'srkt_getup.mp3' },                     -- Getting up after thrown out of level
  -- [CHAR_SOUND_ON_FIRE] = {'wkm_dmg4.mp3'}, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'srk_eh.mp3',                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'srk_dmg1.mp3',                              -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'srkt_atk1.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'srk_atk4.mp3',      -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'srk_atk1.mp3',      -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'srk_bthrow1.mp3', 'srk_bthrow2.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'srk_nn1.mp3' },                           -- Boing
  [CHAR_SOUND_UH] = 'srk_nn2.mp3',                                         -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'srk_nn1.mp3' },                                    -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'srk_throw1.mp3', 'srk_throw2.mp3' },    -- Throw Object
  [CHAR_SOUND_WHOA] = 'srk_nn2.mp3',                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'srk_atk3.mp3' },                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'srk_atk3.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'srk_atk2.mp3', 'srk_atk5.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shun_yawn.mp3'},
}

VT_SERIKA        = {
  [CHAR_SOUND_ATTACKED] = { 'serika_dmg1.mp3', 'serika_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'serika_eh.mp3',                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'serika_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'serika_nyan.mp3' },                            -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'serika_star1.mp3', 'serika_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'serika_atk5.mp3' },                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                         -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'serika_tired.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'serika_atk5.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'serika_ls1.mp3' },                                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'serika_getup.mp3' },                                         -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'serika_dmg3.mp3' },                                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'serika_cho.mp3',                                                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'serika_dmg1.mp3',                                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'serika_atk6.mp3' },                                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'serika_atk1.mp3',                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'serika_atk8.mp3',                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'serika_bthrow1.mp3', 'serika_bthrow2.mp3' },          -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                   -- Boing
  [CHAR_SOUND_UH] = 'serika_eh.mp3',                                                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'serika_atk8.mp3' },                                               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'serika_fall1.mp3',                                             -- Falling
  [CHAR_SOUND_WAH2] = { 'serika_atk6.mp3' },                                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'serika_eh.mp3',                                                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'serika_longjump.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'serika_atk2.mp3', 'serika_longjump2.mp3' },         -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'serika_atk7.mp3', 'serika_atk8.mp3', 'serika_atk1.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'serika_yawn.mp3' },
}

VT_NONOMI        = {
  [CHAR_SOUND_ATTACKED] = { 'nonomi_dmg2.mp3', 'nonomi_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'nonomi_dmg2.mp3',            -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'nonomi_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'nonomi_laugh.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'nonomi_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'nonomi_jump2.mp3' },    -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'nonomi_grab.mp3',           -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'nonomi_sleepy.mp3',
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'nonomi_atk6.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'nonomi_letsGo.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'nonomi_levelFail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'nonomi_burn.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'nonomi_ara.mp3',                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'nonomi_dmg1.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'nonomi_kick.mp3' },          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'nonomi_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'nonomi_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'nonomi_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },    -- Boing
  [CHAR_SOUND_UH] = 'nonomi_ara.mp3',                      -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'nonomi_atk4.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'nonomi_falling.mp3',            -- Falling
  -- [CHAR_SOUND_WAH2] = {'nonomi_throw1.mp3'},-- Throw Object
  [CHAR_SOUND_WHOA] = 'nonomi_grab.mp3',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'nonomi_yahoo.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'nonomi_yahoo.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'nonomi_jump1.mp3' },       -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'nonomi_yawn.mp3'},
}

VT_AYANE         = {
  [CHAR_SOUND_ATTACKED] = { 'ayane_dmg2.mp3', 'ayane_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'ayane_eh.mp3',              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'ayane_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'ayane_laugh.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'ayane_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'ayane_jump2.mp3' },    -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'ayane_grab.mp3',           -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'ayane_sleep.mp3',
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'ayane_atk6.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'ayane_letsGo.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'ayane_levelFail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'ayane_burn.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'ayane_eh.mp3',                     -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'ayane_dmg1.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'ayane_kick.mp3' },          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'ayane_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'ayane_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'ayane_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },   -- Boing
  [CHAR_SOUND_UH] = 'ayane_eh.mp3',                       -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'ayane_atk4.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'ayane_falling.mp3',            -- Falling
  -- [CHAR_SOUND_WAH2] = {'ayane_throw1.mp3'},-- Throw Object
  [CHAR_SOUND_WHOA] = 'ayane_grab.mp3',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'ayane_yahoo.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'ayane_yahoo.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'ayane_jump1.mp3' },       -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'ayane_yawn.mp3'},
}
-- ================
-- Abydos End
-- ================
-- ================
-- Gehenna Start
-- ================
VT_ARU = {
  [CHAR_SOUND_ATTACKED] = { 'aru_dmg1.mp3', 'aru_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'aru_dmg1.mp3',
  [CHAR_SOUND_DYING] = 'aru_dying.mp3',
  [CHAR_SOUND_PUNCH_HOO] = 'aru_kick.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = 'aru_yahoo.mp3',
  [CHAR_SOUND_HAHA] = 'aru_laugh.mp3',
  [CHAR_SOUND_HAHA_2] = 'aru_laugh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'aru_letsGo.mp3', 'aru_letsGo2.mp3' },
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'aru_yahoo.mp3' },
  [CHAR_SOUND_HOOHOO] = 'aru_jump2.mp3',
  [CHAR_SOUND_YAHOO] = 'aru_yahoo.mp3',
  [CHAR_SOUND_EEUH] = 'aru_ledgeUp.mp3',
  [CHAR_SOUND_MAMA_MIA] = { 'aru_levelFail.mp3', 'aru_levelFail2.mp3' },
  [CHAR_SOUND_HRMM] = 'aru_hmm.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'aru_star.mp3', 'aru_bowser2.mp3' },
  [CHAR_SOUND_UH] = 'aru_eh.mp3',
  -- [CHAR_SOUND_UH2] = 'aru_jump1_2.mp3',
  [CHAR_SOUND_OOOF] = 'aru_dmg1.mp3',
  [CHAR_SOUND_YAH_WAH_HOO] = { 'aru_jump1.mp3', 'aru_jump1_2.mp3' },
  [CHAR_SOUND_OOOF2] = 'aru_dmg2.mp3',
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = 'aru_jump3.mp3',
  [CHAR_SOUND_PUNCH_YAH] = 'aru_punch2.mp3',
  [CHAR_SOUND_PUNCH_WAH] = 'aru_punch1.mp3',
  [CHAR_SOUND_WAAAOOOW] = 'aru_falling.mp3',
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'aru_bowser.mp3' },
  [CHAR_SOUND_WHOA] = 'aru_ledgeGrab.mp3',
  [CHAR_SOUND_ON_FIRE] = 'aru_burn.mp3',
  [CHAR_SOUND_IMA_TIRED] = 'aru_yawn.mp3',
}

VT_JUNKO = {
  [CHAR_SOUND_ATTACKED] = { 'junko_dmg1.mp3', 'junko_dmg4.mp3', 'junko_dmg5.mp3' },
  [CHAR_SOUND_DOH] = 'junko_ah1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'junko_dead1.mp3' },
  --[CHAR_SOUND_EEUH] = {'junko_ledgeclimb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'junko_atk5.mp3' },
  [CHAR_SOUND_HAHA] = { 'junko_laugh1.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'junko_star1.mp3', 'junko_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'junko_jump2.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'junko_pickup.mp3',                             -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'junko_tired2.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'junko_ls1.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'junko_getup1.mp3',                         -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'junko_dmg3.mp3' },                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'junko_grabbed.mp3',                            -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'junko_dmg1.mp3',                              -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3',}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'junko_atk4.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'junko_atk1.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'junko_atk2.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'junko_bthrow1.mp3' },             -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'silent.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'junko_ueh.mp3',                                  -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'junko_atk2.mp3' },                            -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'junko_dead2.mp3',                          -- Falling
  [CHAR_SOUND_WAH2] = 'junko_atk5.mp3',                               -- Throw Object
  [CHAR_SOUND_WHOA] = 'junko_ledgegrab.mp3',                          -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'junko_yaho.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'junko_atk4.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'junko_atk2.mp3', 'junko_jump1.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'junko_tired1.mp3' },
}

VT_FUUKA = {
  [CHAR_SOUND_ATTACKED] = { 'fuuka_eh1.mp3' },
  [CHAR_SOUND_DOH] = 'fuuka_eh1.mp3', -- Bonk into walls
  -- [CHAR_SOUND_DYING] = {'.mp3'},
  -- [CHAR_SOUND_EEUH] = {'.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'.mp3'},
  [CHAR_SOUND_HAHA] = { 'fuuka_laugh.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'fuuka_star1.mp3', 'fuuka_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'fuuka_jump2.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'fuuka_grab.mp3',                               -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = '.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'fuuka_ls1.mp3', 'fuuka_ls2.mp3' },      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'fuuka_levelexit.mp3' },                  -- Getting up after thrown out of level
  -- [CHAR_SOUND_ON_FIRE] = {'.mp3'}, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'fuuka_eh2.mp3',                                -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'fuuka_eh1.mp3',                               -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'fuuka_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'fuuka_jump1.mp3',    -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'fuuka_atk2.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'fuuka_bthrow1.mp3', 'fuuka_bthrow2.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'fuuka_jump4.mp3',                                         -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'fuuka_atk2.mp3' },                                     -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'fuuka_atk3.mp3' },                           -- Throw Object
  [CHAR_SOUND_WHOA] = 'fuuka_are1.mp3',                               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'fuuka_grab.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'fuuka_atk3.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'fuuka_jump3.mp3', 'fuuka_atk1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'silent.mp3'},
}

VT_KASUMI = {
  [CHAR_SOUND_ATTACKED] = { 'ksm_dmg1.mp3', 'ksm_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'ksm_oh1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'ksm_getup.mp3' },
  -- [CHAR_SOUND_EEUH] = {'srk_climb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'ksm_bagon.mp3' },
  [CHAR_SOUND_HAHA] = { 'ksm_wonderful.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'ksm_laugh2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'ksm_jump1.mp3' },      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'ksm_grab.mp3',             -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'ksm_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'ksm_ls1.mp3' },     -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'ksm_getup.mp3' },    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'ksm_dmg4.mp3' },      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'ksm_hm2.mp3',              -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'ksm_dmg3.mp3',            -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'ksm_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'ksm_atk4.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'ksm_atk2.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'ksm_bthrow1.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'ksm_boing.mp3' },      -- Boing
  [CHAR_SOUND_UH] = 'ksm_oh1.mp3',                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'ksm_jump1.mp3' },               -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'ksm_surprise.mp3' },                    -- Throw Object
  [CHAR_SOUND_WHOA] = 'ksm_ledgegrab.mp3',                       -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'ksm_longjump.mp3' },                   -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'ksm_atk3.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'ksm_atk5.mp3', 'ksm_atk1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shun_yawn.mp3'},
}

VT_MUTSUKI = {
  [CHAR_SOUND_ATTACKED] = { 'mutsuki_dmg1.mp3', 'mutsuki_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'mutsuki_dmg1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'mutsuki_dying.mp3' },
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'mutsuki_groundPound.mp3' },
  [CHAR_SOUND_HAHA] = { 'mutsuki_laugh.mp3' },                                     -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'mutsuki_star.mp3', 'mutsuki_star2.mp3' },           -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'mutsuki_jump2.mp3' },                                   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'mutsuki_grab.mp3',                                          -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'srk_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'mutsuki_letsGo.mp3' },                               -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'mutsuki_levelFail.mp3', 'mutsuki_levelFail2.mp3' },   -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = 'mutsuki_nani.mp3',                                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'mutsuki_ah.mp3',                                            -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'mutsuki_dmg3.mp3',                                         -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'mutsuki_kick.mp3' },                                 -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'mutsuki_punch2.mp3',                                   -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'mutsuki_punch1.mp3',                                   -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'mutsuki_bowser1.mp3', 'mutsuki_bowser2.mp3' }, -- Bowser Throw
  [CHAR_SOUND_UH] = 'mutsuki_uh.mp3',                                              -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'mutsuki_nani.mp3',                                      -- Falling
  [CHAR_SOUND_WHOA] = 'mutsuki_ah.mp3',                                            -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'mutsuki_kufufu.mp3' },                                   -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'mutsuki_jump3.mp3' },                        -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'mutsuki_jump1.mp3' },                              -- 1st Jump(s)
}

VT_KAYOKO = {
  [CHAR_SOUND_ATTACKED] = { 'kayoko_dmg1.mp3', 'kayoko_dmg2.mp3', 'kayoko_dmg3.mp3' },
  [CHAR_SOUND_DOH] = 'kayoko_dmg1.mp3',                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'kayoko_dying.mp3' },
  [CHAR_SOUND_EEUH] = { 'kayoko_ledgeUp.mp3' },                           -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = 'kayoko_groundPound.mp3',
  [CHAR_SOUND_HAHA] = { 'kayoko_sigh.mp3' },                              -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'kayoko_star.mp3', 'kayoko_star2.mp3' },    -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'kayoko_jump2.mp3' },                           -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'kayoko_grab.mp3',                                  -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'kayoko_yawn.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'kayoko_letsGo.mp3', 'kayoko_letsGo2.mp3' }, -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'kayoko_levelFail.mp3' },                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'kayoko_burn.mp3' },                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'srk_eh.mp3',                                       -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'kayoko_dmg3.mp3',                                 -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'kayoko_kick.mp3' },                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'kayoko_punch2.mp3',                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'kayoko_jump1.mp3',                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kayoko_bowser.mp3' },                 -- Bowser Throw
  [CHAR_SOUND_UH] = 'kayoko_uh.mp3',                                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'kayoko_burn.mp3',                              -- Falling
  [CHAR_SOUND_WHOA] = 'kayoko_eh.mp3',                                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kayoko_yahoo.mp3' },                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kayoko_yahoo.mp3' },                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kayoko_jump1.mp3' },                      -- 1st Jump(s)
}

VT_HARUKA = {
  [CHAR_SOUND_ATTACKED] = { 'haruka_dmg1.mp3', 'haruka_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'haruka_eh.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'haruka_dying.mp3' },
  -- [CHAR_SOUND_EEUH] = {'srk_climb.mp3'}, -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'haruka_yahoo.mp3' },
  [CHAR_SOUND_HAHA] = { 'haruka_laugh.mp3' },                              -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'haruka_star.mp3' },                         -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'haruka_jump2.mp3' },                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'haruka_jump2.mp3',                                  -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'srk_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'haruka_letsGo.mp3' },                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'haruka_levelFail.mp3' },                      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'haruka_falling.mp3' },                         -- Touch Fire
  [CHAR_SOUND_OOOF] = 'haruka_eh.mp3',                                     -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'haruka_dmg2.mp3',                                  -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'haruka_kick.mp3' },                          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'haruka_punch2.mp3',                            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'haruka_jump1.mp3',                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'haruka_bowser2.mp3' },                 -- Bowser Throw
  [CHAR_SOUND_UH] = 'haruka_eh.mp3',                                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'haruka_falling.mp3',                            -- Falling
  [CHAR_SOUND_WHOA] = 'haruka_ledgeGrab.mp3',                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'haruka_yahoo.mp3' },                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'haruka_yahoo.mp3' },                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'haruka_jump1.mp3', 'haruka_jump1_1.mp3' }, -- 1st Jump(s)
}

VT_AKO = {
  [CHAR_SOUND_ATTACKED] = { 'ako_dmg2.mp3', 'ako_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'ako_eh1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'ako_dead1.mp3', 'ako_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {'srk_climb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'ksm_bagon.mp3'},
  [CHAR_SOUND_HAHA] = { 'ako_laugh1.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'ako_star1.mp3', 'ako_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'ako_jump4.mp3' },                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'ako_pickup.mp3',                           -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'ksm_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'ako_ls1.mp3' },                     -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'ako_getup.mp3', 'ako_dmg3.mp3' },    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'ako_onfire.mp3' },                    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'ako_ara1.mp3',                             -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'ako_dmg2.mp3',                            -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'ako_atk2.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'ako_atk3.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'ako_atk4.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'ako_bthrow1.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'ksm_boing.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'ako_eh2.mp3',                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'ako_jump2.mp3' },               -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'ako_throw1.mp3' },                       -- Throw Object
  [CHAR_SOUND_WHOA] = 'ako_huh1.mp3',                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'ako_atk2.mp3' },                        -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'ako_laugh1.mp3' },          -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'ako_atk1.mp3', 'ako_jump4.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'ako_yawn.mp3' },
}

VT_HARUNA = {
  [CHAR_SOUND_ATTACKED] = { 'haruna_dmg1.mp3', 'haruna_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'haruna_dmg1.mp3',  -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'haruna_dying.mp3' },
  [CHAR_SOUND_HRMM] = 'haruna_grab.mp3', -- Object Pick-up
  -- [CHAR_SOUND_EEUH] = {'mmr_slowclimb.mp3'}, -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'haruna_punch2.mp3' },
  [CHAR_SOUND_HAHA] = { 'haruna_laugh.mp3' },              -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = 'haruna_laugh.mp3',                -- Landing on Water after a fall
  [CHAR_SOUND_HERE_WE_GO] = { 'haruna_star.mp3' },         -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'haruna_punch2.mp3' },           -- 2nd Jump + Dive Attack
  [CHAR_SOUND_IMA_TIRED] = 'haruna_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'haruna_letsGo.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'haruna_levelFail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'haruna_burn.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'haruna_eh.mp3',                     -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'haruna_dmg2.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'haruna_punch1.mp3' },        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'haruna_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'haruna_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'haruna_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_UH] = 'haruna_eh.mp3',                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'haruna_jump1.mp3' },               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'haruna_burn.mp3',               -- Falling
  [CHAR_SOUND_WAH2] = { 'haruna_punch1.mp3' },             -- Throw Object
  [CHAR_SOUND_WHOA] = 'haruna_grab.mp3',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'haruna_yahoo.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'haruna_jump3.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'haruna_jump1.mp3' },       -- 1st Jump(s)
}

VT_IBUKI = {
  [CHAR_SOUND_ATTACKED] = { 'ibuki_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'ibuki_ledge.mp3',                                                 -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'ibuki_dead2.mp3', 'ibuki_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'ibuki_jaan.mp3' },                                             -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'ibuki_star1.mp3', 'ibuki_star2.mp3' },                   -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'ibuki_atk2.mp3' },                                           -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                         -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'ibuki_atk3.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'ibuki_ls.mp3' },                                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'ibuki_levelexit.mp3' },                                    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'ibuki_fire.mp3' },                                          -- Touch Fire
  [CHAR_SOUND_OOOF] = 'ibuki_hm.mp3',                                                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'ibuki_dmg1.mp3',                                                -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'ibuki_atk3.mp3' },                                        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'ibuki_atk4.mp3',                                            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'ibuki_atk1.mp3',                                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'ibuki_bthrow.mp3' },                                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                 -- Boing
  [CHAR_SOUND_UH] = 'ibuki_ledge.mp3',                                                  -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'ibuki_jump1.mp3' },                                             -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'ibuki_dmg2.mp3',                                             -- Falling
  [CHAR_SOUND_WAH2] = { 'ibuki_throw.mp3' },                                            -- Throw Object
  [CHAR_SOUND_WHOA] = 'ibuki_ah1.mp3',                                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'ibuki_longjump.mp3' },                                        -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'ibuki_longjump.mp3' },                            -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'ibuki_jump1.mp3', 'ibuki_atk1.mp3', 'ibuki_atk4.mp3' }, -- 1st Jump(s)
}

VT_AKARI = {
  [CHAR_SOUND_ATTACKED] = { 'akari_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'akari_ara.mp3',              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'akari_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'akari_giggle.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'akari_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'akari_jump1.mp3' },     -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',    -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = 'serika_tired.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'akari_atk1.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'akari_ls1.mp3' },                                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'akari_levelexit.mp3' },                                   -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'akari_burn.mp3' },                                         -- Touch Fire
  [CHAR_SOUND_OOOF] = 'akari_ara.mp3',                                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'akari_dmg1.mp3',                                               -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'akari_kick.mp3' },                                       -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'akari_atk2.mp3',                                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'akari_atk1.mp3',                                           -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'akari_throw1.mp3' },                               -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                -- Boing
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                             -- Drop off of ledge + Fall off Ledge
  --[CHAR_SOUND_UH2] = {'serika_atk8.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                     -- Falling
  [CHAR_SOUND_WAH2] = { 'akari_throw1.mp3' },                                          -- Throw Object
  [CHAR_SOUND_WHOA] = 'akari_ara.mp3',                                                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'akari_longjump.mp3' },                                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'akari_kick.mp3', 'akari_longjump.mp3' },         -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'akari_atk3.mp3', 'akari_atk4.mp3', 'akari_atk1.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'akari_yawn.mp3' },
}

VT_MEGU = {
  [CHAR_SOUND_ATTACKED] = { 'megu_dmg1.mp3', 'megu_dmg3.mp3', 'megu_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'megu_bonk2.mp3',                              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'megu_defeat.mp3' },
  [CHAR_SOUND_HAHA] = { 'megu_laugh1.mp3' },                        -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'megu_star1.mp3', 'megu_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'megu_ls1.mp3' },                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'megu_levelexit.mp3' },                 -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                     -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'megu_atk2.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                   -- Touch Fire
  [CHAR_SOUND_OOOF] = 'megu_bonk.mp3',                              -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'megu_dmg1.mp3',                             -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'megu_atk4.mp3' },                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'megu_atk2.mp3',                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'megu_atk3.mp3',                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'megu_bthrow.mp3' },             -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'megu_throw.mp3' },                         -- Throw Object
  [CHAR_SOUND_UH] = 'megu_drop.mp3',                                -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'megu_fall.mp3',                          -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },             -- Boing
  [CHAR_SOUND_WHOA] = 'megu_ledgegrab.mp3',                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'megu_longjump.mp3' },                     -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'megu_laugh2.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'megu_atk1.mp3' },                   -- 1st Jump(s)
}

VT_IORI = {
  [CHAR_SOUND_ATTACKED] = { 'iori_dmg1.mp3', 'iori_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'iori_bonk.mp3',                               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'iori_defeat1.mp3', 'iori_defeat2.mp3' },
  [CHAR_SOUND_HERE_WE_GO] = { 'iori_star1.mp3', 'iori_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'iori_ls1.mp3' },                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'iori_levelexit.mp3' },
  [CHAR_SOUND_HRMM] = 'iori_grab.mp3',                              -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'iori_atk2.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'iori_dmg2.mp3' },                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'iori_grabbed.mp3',                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'iori_dmg3.mp3',                             -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'iori_atk3.mp3' },                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'iori_atk2.mp3',                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'iori_atk1.mp3',                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'iori_bthrow1.mp3' },            -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'iori_throw1.mp3' },                        -- Throw Object
  [CHAR_SOUND_UH] = 'iori_bonk.mp3',                                -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'iori_fall.mp3',                          -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },             -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                        -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'iori_atk3.mp3' },                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'iori_atk3.mp3' },             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'iori_atk1.mp3' },                   -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'iori_sigh.mp3' },
}

VT_HINA          = {
  [CHAR_SOUND_ATTACKED] = { 'hina_dmg2.mp3', 'hina_dmg5.mp3' },
  [CHAR_SOUND_DOH] = 'hina_dmg1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hina_dead1.mp3', 'hina_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {nil,}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = nil, -- Game Over Voiceline
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'hina_atk3.mp3' },
  [CHAR_SOUND_HAHA] = 'hina_ok.ogg',
  -- [CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = nil, -- Intro Voiceline
  [CHAR_SOUND_HERE_WE_GO] = { 'hina_starget1.mp3', 'hina_starget2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'hina_atk3.mp3',                                  -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'hina_grab.mp3',                                    -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'hina_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'hina_levelselect.mp3' },                    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'hina_annoying1.mp3' },                       -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'hina_what.mp3' },                             -- Touch Fire
  [CHAR_SOUND_OOOF] = 'hina_dmg1.mp3',                                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'hina_dmg1.mp3',                                   -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {nil,}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = nil,
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'hina_atk4.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'hina_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'hina_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = nil,
  -- [CHAR_SOUND_SNORING2] = nil,
  -- [CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hina_nomercy.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = nil, -- Boing
  [CHAR_SOUND_UH] = 'hina_nn.mp3',                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'hina_atk3.mp3' },                -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = nil, -- Falling
  [CHAR_SOUND_WAH2] = 'hina_throw.mp3',                 -- Throw Object
  [CHAR_SOUND_WHOA] = 'hina_ledgegrab.mp3',             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hina_atk5.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hina_atk5.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hina_atk2.mp3' }        -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = nil,
}

VT_SENA          = {
  [CHAR_SOUND_ATTACKED] = { 'Sena_dmg1.mp3', 'Sena_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'Sena_dmg2.mp3',                                      -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Sena_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'Sena_HAHA.mp3' },                                 -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Sena_herewego.mp3', 'Sena_herewego2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'Sena_punch1.mp3' },                             -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'Sena_grab.mp3',                                     -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'Sena_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'Sena_jump3.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'Sena_enterlevel.mp3' },          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Sena_faillevel.mp3' },            -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'Sena_dmg1.mp3' },                  -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Sena_dmg2.mp3',                         -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Sena_dmg1.mp3',                        -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Sena_kick.mp3' },                -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Sena_punch2.mp3',                  -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Sena_punch1.mp3',                  -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Sena_bowser.mp3' },        -- Bowser Throw
  [CHAR_SOUND_UH] = 'Sena_dmg2.mp3',                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Sena_ledgeup2.mp3' },                  -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Sena_dmg2.mp3',                     -- Falling
  [CHAR_SOUND_WAH2] = { 'Sena_ledgeup2.mp3' },                 -- Throw Object
  [CHAR_SOUND_WHOA] = 'Sena_ledgegrab.mp3',                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Sena_kick.mp3' },                    -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Sena_groundpound.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Sena_punch2.mp3' },            -- 1st Jump(s)
  [CHAR_SOUND_EEUH] = 'Sena_ledgeup.mp3',
}

VT_CHIAKI        = {
  [CHAR_SOUND_ATTACKED] = { 'chiaki_dmg1.mp3', 'chiaki_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'chiaki_are.mp3',                                                      -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'chiaki_dead1.mp3', 'chiaki_dead2.mp3' },
  [CHAR_SOUND_HAHA] = { 'chiaki_wuhaa.mp3' },                                               -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'chiaki_star2.mp3', 'chiaki_star4.mp3', 'chiaki_star5.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'chiaki_levelstart.mp3' },                                     -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'chiaki_levelexit.mp3' },                                       -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'chiaki_grab.mp3',                                                    -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'chiaki_atk4.mp3' },                                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'chiaki_wah4.mp3',                                                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'chiaki_dmg2.mp3',                                                   -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'chiaki_atk3.mp3' },                                           -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'chiaki_atk1.mp3',                                               -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'chiaki_atk2.mp3',                                               -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'chiaki_bthrow.mp3' },                                   -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'chiaki_throw1.mp3', 'chiaki_throw2.mp3' },                         -- Throw Object
  [CHAR_SOUND_UH] = 'chiaki_wah3.mp3',                                                      -- Drop off of ledge + Fall off Ledge
  --[CHAR_SOUND_UH2] = { 'rei_atk2.mp3' },              					-- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'chiaki_fall.mp3',                                                -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                     -- Boing
  [CHAR_SOUND_WHOA] = { 'chiaki_ledgegrab.mp3', 'chiaki_wah.mp3' },                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'chiaki_atk3.mp3' },                                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'chiaki_atk3.mp3' },                                   -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'chiaki_jump.mp3', 'chiaki_atk2.mp3' },                      -- 1st Jump(s)
  [CHAR_SOUND_IMA_TIRED] = 'chiaki_relax.mp3',
}

VT_IROHA         = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3', 'sfx_smrpg_shell.mp3', 'sfx_smw_bossstun.mp3' },
  [CHAR_SOUND_DOH] = 'iroha_eh.mp3',                                                     -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'iroha_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'iroha_laugh.mp3' },                                             -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'iroha_star1.mp3', 'iroha_star2.mp3', 'iroha_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'iroha_ls1.mp3' },                                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'iroha_levelexit1.mp3' },                                    -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                          -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'iroha_sigh.mp3',
  [CHAR_SOUND_HOOHOO] = { 'iroha_atk6.mp3' },                                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sfx_pm64_what.mp3',                                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                             -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'iroha_atk5.mp3' },                                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'iroha_atk3.mp3',                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'iroha_atk8.mp3',                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'iroha_attack.mp3' },                                 -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'iroha_throw1.mp3' },                                            -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'iroha_annoying.mp3',                                          -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                  -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'iroha_atk5.mp3' },                                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'iroha_atk5.mp3' },                                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'iroha_atk8.mp3', 'iroha_atk7.mp3', 'iroha_atk1.mp3' },   -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'iroha_yawn.mp3' },
}

VT_MAKOTO        = {
  [CHAR_SOUND_ATTACKED] = { 'Makoto_ATTACKED1.ogg', 'Makoto_ATTACKED2.ogg', },
  [CHAR_SOUND_DOH] = 'Makoto_DOH.ogg',                                                     -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Makoto_DYING.ogg', 'Makoto_OOOF2.ogg' },
  [CHAR_SOUND_HAHA] = { 'Makoto_HAHA.ogg', 'Makoto_HAHA2.ogg', 'Makoto_HAHA3.ogg', 'Makoto_HAHA4.ogg'},                                             -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Makoto_HERE_WE_GO1.ogg', 'Makoto_HERE_WE_GO2.ogg'}, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'Makoto_LETS_A_GO.ogg' },                                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Makoto_MAMA_MIA.ogg' },                                    -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'Makoto_HRMM.ogg',                                          -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'Makoto_YAWN.ogg',
  [CHAR_SOUND_HOOHOO] = { 'Makoto_HOOHOO.ogg' },                                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Makoto_ON_FIRE.ogg' },                                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Makoto_UH.ogg',                                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Makoto_ATTACKED2.ogg',                                             -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Makoto_PUNCH_HOO.ogg' },                                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Makoto_PUNCH_WAH.ogg',                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Makoto_PUNCH_YAH.ogg',                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Makoto_WAH2.ogg' },                                 -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'Makoto_WAH2.ogg' },                                            -- Throw Object
  [CHAR_SOUND_UH] = 'Makoto_UH.ogg',                                               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'Makoto_WAAAOOOW.ogg',                                          -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'Makoto_TWIRL_BOUNCE.ogg' },                                  -- Boing
  [CHAR_SOUND_WHOA] = 'Makoto_WHOA.ogg',                                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Makoto_YAHOO.ogg' },                                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Makoto_YAHOO_WAHA_YIPPEE.ogg' },                                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Makoto_YAH_WAH_HOO.ogg', 'Makoto_YAH_WAH_HOO2.ogg', 'Makoto_YAH_WAH_HOO3.ogg' },   -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = { 'Makoto_YAWN.ogg' },
}

VT_SATSUKI        = {
  [CHAR_SOUND_ATTACKED] = { 'Satsuki_ATTACKED.ogg', 'Satsuki_ATTACKED2.ogg' },
  [CHAR_SOUND_DOH] = 'Satsuki_DOH.ogg',                                                     -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Satsuki_DYING.ogg', },
  [CHAR_SOUND_HAHA] = { 'Satsuki_HAHA.ogg'},                                             -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Satsuki_HEREWEGO.ogg', 'Satsuki_HEREWEGO2.ogg'}, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'satsuki_levelselect.mp3', 'Satsuki_LETSAGO.ogg' },                                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'satsuki_nofair.mp3' },                                    -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                          -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'Satsuki_IMATIRED.ogg',
  [CHAR_SOUND_HOOHOO] = { 'Satsuki_HOOHOO.ogg' },                                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Satsuki_ATTACKED.ogg' },                                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Satsuki_UH.ogg',                                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Satsuki_OOOF2.ogg',                                             -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Satsuki_PUNCH_HOO.ogg' },                                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Satsuki_HOOHOO.ogg',                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Satsuki_YAH_WAH_HOO2.ogg',                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_ssb64_itemthrow.mp3' },                                 -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'satsuki_throw.mp3' },                                 -- Throw Object
  [CHAR_SOUND_UH] = 'Satsuki_UH.ogg',                                               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'Satsuki_WAAAOOOW.ogg',                                          -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                  -- Boing
  [CHAR_SOUND_WHOA] = 'Satsuki_OOOF2.ogg',                                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Satsuki_YAHOO.ogg' },                                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Satsuki_YAHOO_WAHA_YIPPEE.ogg' },                                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Satsuki_YAH_WAH_HOO.ogg', 'Satsuki_YAH_WAH_HOO2.ogg',},   -- 1st Jump(s)
}

-- ================
-- Gehenna End
-- ================
-- ================
-- Highlander Start
-- ================

VT_HIKARI        = {
  [CHAR_SOUND_ATTACKED] = { 'hikari_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'hikari_bonk.mp3',                                                                         -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hikari_dead2.mp3', 'hikari_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'hikari_jan.mp3' },                                                                     -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'hikari_star1.mp3', 'hikari_star2.mp3', 'hikari_star3.mp3', 'hikari_star4.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'hikari_jump1.mp3' },                                                                 -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'hikari_pickup.mp3',                                                                      -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'hikari_tired.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'hikari_atk3.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'hikari_levelselect.mp3' },                                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'hikari_getup1.mp3', 'hikari_getup2.mp3', 'hikari_levelexit.mp3' }, -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'hikari_dmg2.mp3' },                                                 -- Touch Fire
  [CHAR_SOUND_OOOF] = 'hikari_drop.mp3',                                                        -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'hikari_bonk.mp3',                                                       -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'hikari_atk3.mp3' },                                               -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'hikari_atk2.mp3',                                                   -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'hikari_atk1.mp3',                                                   -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hikari_bthrow.mp3' },                                       -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                         -- Boing
  [CHAR_SOUND_UH] = 'hikari_drop.mp3',                                                          -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'hikari_atk2.mp3' },                                                     -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'hikari_fall.mp3',                                                    -- Falling
  [CHAR_SOUND_WAH2] = { 'hikari_throw.mp3' },                                                   -- Throw Object
  --[CHAR_SOUND_WHOA] = 'ibuki_ah1.mp3',                                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hikari_longjump.mp3' },                                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hikari_longjump.mp3' },                                   -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hikari_atk1.mp3', 'hikari_jump2.mp3', 'hikari_atk2.mp3' },      -- 1st Jump(s)
}

VT_NOZOMI        = {
  [CHAR_SOUND_ATTACKED] = { 'nozomi_dmg1.mp3', 'nozomi_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'nozomi_bonk2.mp3',                                         -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'nozomi_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'nozomi_laugh2.mp3' },                                   -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'nozomi_star1.mp3', 'nozomi_star2.mp3' },          -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'nozomi_atk5.mp3' },                                   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'nozomi_grab.mp3',                                         -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'nozomi_atk3.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'nozomi_ls1.mp3' },                                 -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'nozomi_getup.mp3' },                                -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'nozomi_fire.mp3' },                                  -- Touch Fire
  [CHAR_SOUND_OOOF] = 'nozomi_bonk3.mp3',                                        -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'nozomi_geh.mp3',                                         -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'nozomi_atk2.mp3' },                                -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'nozomi_atk4.mp3',                                    -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'nozomi_atk1.mp3',                                    -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'nozomi_bthrow.mp3' },                        -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                          -- Boing
  [CHAR_SOUND_UH] = 'nozomi_bonk1.mp3',                                          -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'nozomi_atk5.mp3' },                                      -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'nozomi_fall.mp3',                                     -- Falling
  [CHAR_SOUND_WAH2] = { 'nozomi_laugh3.mp3' },                                   -- Throw Object
  [CHAR_SOUND_WHOA] = 'nozomi_bonk3.mp3',                                        -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'nozomi_laugh1.mp3' },                                  -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'nozomi_longjump.mp3', 'nozomi_atk3.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'nozomi_atk1.mp3', 'nozomi_atk4.mp3' },           -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'nozomi_yawn.mp3' },
}

VT_AOBA          = {
  [CHAR_SOUND_ATTACKED] = { 'aoba_dmg1.mp3', 'aoba_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'aoba_bonk.mp3',                               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'aoba_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'aoba_push.mp3' },                          --Ledge Climb
  [CHAR_SOUND_HAHA] = { 'aoba_heehee.mp3' },                        -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'aoba_star1.mp3', 'aoba_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'aoba_atk3.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                     -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'aoba_atk4.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'aoba_ls1.mp3' },                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'aoba_thissucks.mp3' },                 -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'aoba_fall.mp3' },                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'aoba_dmg4.mp3',                              -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'aoba_dmg3.mp3',                             -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'aoba_atk2.mp3' },                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'aoba_atk6.mp3',                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'aoba_atk5.mp3',                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'aoba_atk4.mp3' },               -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },             -- Boing
  [CHAR_SOUND_UH] = 'aoba_eh.mp3',                                  -- Drop off of ledge + Fall off Ledge
  --[CHAR_SOUND_UH2] = { 'nozomi_atk5.mp3' },                                             -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'aoba_fall.mp3',                          -- Falling
  [CHAR_SOUND_WAH2] = { 'aoba_throw.mp3' },                         -- Throw Object
  [CHAR_SOUND_WHOA] = 'aoba_eh.mp3',                                -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'aoba_atk4.mp3' },                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'aoba_atk4.mp3' },             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'aoba_atk1.mp3', 'aoba_jump1.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'aoba_yawn.mp3' },
}
-- ================
-- Highlander End
-- ================
